#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h> 
#include <stdio.h>
#include <string>
#include <iostream>

#include "HttpParser.h"

#define CHAR                    char
#define INT                     int
#define UINT                    unsigned int
#define LONGL                   long long
#define FLOAT                   float
#define VOID                    void

#define BUFFER_SIZE             102400                      //buffer大小
#define PORT                    10022                       //端口号
#define MAX_QUE_CONN_NM         5                           //监听链接
#define DATA_INTERFACE          "/radarDataCollect/objData" //数据接口
#define HTTP_HEADER             "\r\n\r\n\r\n"              //报文头部标志
#define HTTP_TAIL               "\n}"                       //报文尾部标志

VOID PkgDistribute(std::string &strBuffer, std::string &jsonstr, CHAR *buffer)
{
    //http解码器
    HttpRequest httpParser;
    strBuffer = strBuffer + std::string(buffer);

    //字符串缓存太短时跳过流程
    if(strBuffer.size() < 128)
    {
        return;
    }

    INT headPos = strBuffer.find(HTTP_HEADER, 0);
    INT tailPos = strBuffer.find(HTTP_TAIL, 0);
    //没头
    if(std::string::npos == headPos)
    {
        //没头没尾
        if(std::string::npos == tailPos)
        {
            //清空buffer等新报文
            strBuffer.clear();
        }
        else
        {
            //没头有尾，偏移截止到包尾的脏数据
            strBuffer = strBuffer.substr(tailPos + 2);
        }
    }
    else
    {
        //有头没尾
        if(std::string::npos == tailPos)
        {
            //继续等新报文
        }
        else
        {
            //有头有尾，切一个完整的包出来
            INT pkg_length = tailPos + 2 - headPos;
            jsonstr = strBuffer.substr(headPos, pkg_length);
            //偏移掉一帧完整的数据
            strBuffer = strBuffer.substr(tailPos + 2);
        }
    }

    //api判断，是否是object数据（统计数据包含在一起混着推的，需要分辨出object数据）
    if(std::string::npos != jsonstr.find(DATA_INTERFACE))
    {
        // //http解码
        // httpParser.tryDecode(jsonstr);
        // jsonstr = httpParser.getBody();
        // //解码的json字符串，先去除一下特殊字符
        // removeSpacesAndNewlines(jsonstr);
        // //数据解包封装
        // jsonParser();
        std::cout << "jsonstr: " << jsonstr.length() << std::endl;
        std::cout << "strBuffer================================================: " << strBuffer.capacity() << "  " << strBuffer.length() << std::endl;
    }

    return;
}

int main ()
{
    INT                         serverFd;
    INT                         clientFd;
    struct sockaddr_in          server_sockaddr;            //服务器地址
    struct sockaddr_in          client_sockaddr;            //申请连接的客户端地址
    CHAR                        buffer[BUFFER_SIZE] = {0};  //报文BUFFER
    std::string                 jsonstr = "";               //切片出的目标数据字符串
    std::string                 strBuffer = "";             //字符串buffer
    std::cout << "start================================================: " << strBuffer.capacity() << "  " << strBuffer.length() << std::endl;
    if ((serverFd = socket(AF_INET,SOCK_STREAM,0))== -1)
    {
        perror("init failed");
        return -1;
    }

    server_sockaddr.sin_family        = AF_INET;
    server_sockaddr.sin_port          = htons(PORT);
    server_sockaddr.sin_addr.s_addr   = htonl(INADDR_ANY);

    INT opt = 1;
    setsockopt(serverFd, SOL_SOCKET, SO_REUSEADDR, &opt, sizeof(opt));

    if (bind(serverFd, (struct sockaddr *)&server_sockaddr,sizeof(struct sockaddr)) == -1)
    {
        perror("bind failed");
        close(serverFd);
        return -1;
    }

    INT recvbytes = 0;
    socklen_t addr_size = sizeof(client_sockaddr);

    if (listen(serverFd, MAX_QUE_CONN_NM) == -1)
    {
        perror("listen failed");
        goto finish;
    }

    
    if ((clientFd = accept(serverFd, (struct sockaddr *)&client_sockaddr, &addr_size)) == -1)
    {
        perror("accept failed");
        goto finish;
    }

    while(true)
    {
        memset(buffer , 0, sizeof(buffer));
        jsonstr.clear();

        recvbytes = recv(clientFd, buffer, BUFFER_SIZE, 0);
        std::cout << "recvbytes: " << recvbytes << std::endl;

        if (0 > recvbytes)
        {
            perror("connect failed");
            goto finish;
        }

        //掉线
        if(0 == recvbytes)
        {
            close(clientFd);
            if ((clientFd = accept(serverFd, (struct sockaddr *)&client_sockaddr, &addr_size)) == -1)
            {
                perror("accept failed");

                //sleep 50ms then continue to reconect
                sleep(0.05);
                continue;
            }
            //重连成功跳过处理过程先接新报文
            continue;
        }

        //报文接收成功，解析报文
        PkgDistribute(strBuffer, jsonstr, buffer);
    }

finish:
    if(-1 != serverFd)
    {
        close(serverFd);
        serverFd = -1;
    }
    if(-1 != clientFd)
    {
        close(clientFd);
        clientFd = -1;
    }

    return 0;
}
