#include <opencv2/opencv.hpp>
#include <iostream>
#include <ctime>
#include <chrono>

void addTimestampWatermark(const std::string& inputImagePath, const std::string& outputImagePath) 
{
    cv::Mat image = cv::imread(inputImagePath);
    if (image.empty()) 
    {
        std::cerr << "read failed: " << inputImagePath << std::endl;
        return;
    }

    while(true)
    {
        auto start = std::chrono::high_resolution_clock::now();

        int loop = 100000;
        for(int i = 0; i < loop; ++i)
        {
            std::time_t now = std::time(nullptr);
            char timestamp[100];
            std::strftime(timestamp, sizeof(timestamp), "%Y-%m-%d %H:%M:%S", std::localtime(&now));
            cv::Point textOrg(10, 30); // 水印位置
            int fontFace = cv::FONT_HERSHEY_SIMPLEX;
            double fontScale = 1;
            int thickness = 2;
            cv::Scalar color(255, 255, 255); // 白色
            cv::putText(image, timestamp, textOrg, fontFace, fontScale, color, thickness);
        }

        auto end = std::chrono::high_resolution_clock::now();
        std::chrono::duration<double, std::micro> elapsed = end - start;
        std::cout << "使用时间: " << (int)(elapsed.count()/loop) << " us" << std::endl;
    }

    cv::imwrite(outputImagePath, image);
}

int main() 
{
    std::string inputImagePath = "1.jpg";
    std::string outputImagePath = "2.jpg";

    addTimestampWatermark(inputImagePath, outputImagePath);
    std::cout << "finish: " << outputImagePath << std::endl;

    return 0;
}
